/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.monsters.thebeyond;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.MathUtils;
import com.esotericsoftware.spine.AnimationState;
import com.esotericsoftware.spine.Bone;
import com.megacrit.cardcrawl.actions.AbstractGameAction;
import com.megacrit.cardcrawl.actions.ClearCardQueueAction;
import com.megacrit.cardcrawl.actions.GameActionManager;
import com.megacrit.cardcrawl.actions.animations.AnimateFastAttackAction;
import com.megacrit.cardcrawl.actions.animations.AnimateSlowAttackAction;
import com.megacrit.cardcrawl.actions.animations.ShoutAction;
import com.megacrit.cardcrawl.actions.animations.VFXAction;
import com.megacrit.cardcrawl.actions.common.ApplyPowerAction;
import com.megacrit.cardcrawl.actions.common.ChangeStateAction;
import com.megacrit.cardcrawl.actions.common.DamageAction;
import com.megacrit.cardcrawl.actions.common.EscapeAction;
import com.megacrit.cardcrawl.actions.common.HealAction;
import com.megacrit.cardcrawl.actions.common.RollMoveAction;
import com.megacrit.cardcrawl.actions.common.SetMoveAction;
import com.megacrit.cardcrawl.actions.unique.CanLoseAction;
import com.megacrit.cardcrawl.actions.utility.SFXAction;
import com.megacrit.cardcrawl.cards.DamageInfo;
import com.megacrit.cardcrawl.core.AbstractCreature;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.core.Settings;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.MonsterStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.monsters.thebottom.Cultist;
import com.megacrit.cardcrawl.powers.AbstractPower;
import com.megacrit.cardcrawl.powers.CuriosityPower;
import com.megacrit.cardcrawl.powers.DarknessPower;
import com.megacrit.cardcrawl.powers.RegeneratePower;
import com.megacrit.cardcrawl.powers.UnawakenedPower;
import com.megacrit.cardcrawl.relics.AbstractRelic;
import com.megacrit.cardcrawl.unlock.UnlockTracker;
import com.megacrit.cardcrawl.vfx.AwakenedEyeParticle;
import com.megacrit.cardcrawl.vfx.AwakenedWingParticle;
import com.megacrit.cardcrawl.vfx.SpeechBubble;
import com.megacrit.cardcrawl.vfx.combat.IntenseZoomEffect;
import com.megacrit.cardcrawl.vfx.combat.ShockWaveEffect;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AwakenedOne
extends AbstractMonster {
    private static final Logger logger = LogManager.getLogger(AwakenedOne.class.getName());
    public static final String ID = "AwakenedOne";
    private static final MonsterStrings monsterStrings = CardCrawlGame.languagePack.getMonsterStrings("AwakenedOne");
    public static final String NAME = AwakenedOne.monsterStrings.NAME;
    public static final String[] MOVES = AwakenedOne.monsterStrings.MOVES;
    public static final String[] DIALOG = AwakenedOne.monsterStrings.DIALOG;
    public static final int STAGE_1_HP = 320;
    public static final int STAGE_2_HP = 240;
    private boolean form1 = true;
    private boolean firstTurn = true;
    private boolean saidPower = false;
    private static final byte SLASH = 1;
    private static final byte SOUL_STRIKE = 2;
    private static final byte REBIRTH = 3;
    private static final String SS_NAME = MOVES[0];
    private static final int SLASH_DMG = 10;
    private static final int SS_DMG = 6;
    private static final int SS_AMT = 3;
    private static final int REGEN_AMT = 10;
    private static final int STR_AMT = 2;
    private static final byte DARK_ECHO = 5;
    private static final byte SLUDGE = 6;
    private static final byte TACKLE = 8;
    private static final String DARK_ECHO_NAME = MOVES[1];
    private static final String SLUDGE_NAME = MOVES[3];
    private static final int ECHO_DMG = 32;
    private static final int SLUDGE_DMG = 12;
    private static final int TACKLE_DMG = 10;
    private static final int TACKLE_AMT = 2;
    private float fireTimer = 0.0f;
    private static final float FIRE_TIME = 0.1f;
    private Bone eye;
    private Bone back;
    private boolean animateParticles = false;
    private ArrayList<AwakenedWingParticle> wParticles = new ArrayList();

    public AwakenedOne(float x, float y) {
        super(NAME, ID, 320, 40.0f, -30.0f, 460.0f, 250.0f, null, x, y);
        this.loadAnimation("images/monsters/theForest/awakenedOne/skeleton.atlas", "images/monsters/theForest/awakenedOne/skeleton.json", 1.0f);
        AnimationState.TrackEntry e = this.state.setAnimation(0, "idle", true);
        e.setTime(e.getEndTime() * MathUtils.random());
        e.setTimeScale(1.3f);
        this.state.getData().setMix("idle", "growingwings", 0.5f);
        this.eye = this.skeleton.findBone("eye");
        for (Bone b : this.skeleton.getBones()) {
            logger.info(b.getData().getName());
        }
        this.back = this.skeleton.findBone("wingbone");
        this.type = AbstractMonster.EnemyType.BOSS;
        this.dialogX = -200.0f * Settings.scale;
        this.dialogY = 10.0f * Settings.scale;
        this.damage.add(new DamageInfo(this, 10));
        this.damage.add(new DamageInfo(this, 6));
        this.damage.add(new DamageInfo(this, 32));
        this.damage.add(new DamageInfo(this, 12));
        this.damage.add(new DamageInfo(this, 10));
    }

    @Override
    public void usePreBattleAction() {
        CardCrawlGame.music.unsilenceBGM();
        AbstractDungeon.scene.fadeOutAmbiance();
        AbstractDungeon.getCurrRoom().playBgmInstantly("BOSS_BEYOND");
        AbstractDungeon.getCurrRoom().cannotLose = true;
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new RegeneratePower(this, 10)));
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new CuriosityPower(this, 2)));
        AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(this, this, new UnawakenedPower(this)));
        UnlockTracker.markBossAsSeen("CROW");
    }

    @Override
    public void takeTurn() {
        switch (this.nextMove) {
            case 1: {
                AbstractDungeon.actionManager.addToBottom(new AnimateSlowAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(0), AbstractGameAction.AttackEffect.SLASH_DIAGONAL));
                break;
            }
            case 2: {
                for (int i = 0; i < 3; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(1), AbstractGameAction.AttackEffect.FIRE));
                }
                break;
            }
            case 3: {
                AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_AWAKENEDONE_1"));
                AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new IntenseZoomEffect(this.hb.cX, this.hb.cY, true), 0.05f, true));
                AbstractDungeon.actionManager.addToBottom(new ChangeStateAction(this, "REBIRTH"));
                break;
            }
            case 5: {
                this.firstTurn = false;
                AbstractDungeon.actionManager.addToBottom(new SFXAction("VO_AWAKENEDONE_3"));
                AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new ShockWaveEffect(this.hb.cX, this.hb.cY, new Color(0.1f, 0.0f, 0.2f, 1.0f), ShockWaveEffect.ShockWaveType.CHAOTIC), 0.3f));
                AbstractDungeon.actionManager.addToBottom(new VFXAction(this, new ShockWaveEffect(this.hb.cX, this.hb.cY, new Color(0.3f, 0.2f, 0.4f, 1.0f), ShockWaveEffect.ShockWaveType.CHAOTIC), 1.0f));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(2), AbstractGameAction.AttackEffect.SMASH));
                break;
            }
            case 6: {
                AbstractDungeon.actionManager.addToBottom(new AnimateFastAttackAction(this));
                AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(3), AbstractGameAction.AttackEffect.POISON));
                AbstractDungeon.actionManager.addToBottom(new ApplyPowerAction(AbstractDungeon.player, this, new DarknessPower(1), 1));
                break;
            }
            case 8: {
                for (int i = 0; i < 2; ++i) {
                    AbstractDungeon.actionManager.addToBottom(new DamageAction((AbstractCreature)AbstractDungeon.player, (DamageInfo)this.damage.get(4), AbstractGameAction.AttackEffect.FIRE));
                }
                break;
            }
        }
        AbstractDungeon.actionManager.addToBottom(new RollMoveAction(this));
    }

    @Override
    public void changeState(String key) {
        this.maxHealth = 240;
        AnimationState.TrackEntry e = this.state.setAnimation(0, "growingwings", true);
        e.setTimeScale(0.2f);
        this.halfDead = false;
        this.animateParticles = true;
        AbstractDungeon.actionManager.addToBottom(new HealAction(this, this, 200));
        AbstractDungeon.actionManager.addToBottom(new CanLoseAction());
    }

    @Override
    protected void getMove(int num) {
        if (this.form1) {
            if (this.firstTurn) {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 10);
                this.firstTurn = false;
                return;
            }
            if (num < 25) {
                if (!this.lastMove((byte)2)) {
                    this.setMove(SS_NAME, (byte)2, AbstractMonster.Intent.ATTACK, 6, 3, true);
                } else {
                    this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 10);
                }
            } else if (!this.lastTwoMoves((byte)1)) {
                this.setMove((byte)1, AbstractMonster.Intent.ATTACK, 10);
            } else {
                this.setMove(SS_NAME, (byte)2, AbstractMonster.Intent.ATTACK, 6, 3, true);
            }
        } else {
            if (this.firstTurn) {
                this.setMove(DARK_ECHO_NAME, (byte)5, AbstractMonster.Intent.ATTACK, 32);
                return;
            }
            if (num < 50) {
                if (!this.lastTwoMoves((byte)6)) {
                    this.setMove(SLUDGE_NAME, (byte)6, AbstractMonster.Intent.ATTACK_DEBUFF, 12);
                } else {
                    this.setMove((byte)8, AbstractMonster.Intent.ATTACK, 10, 2, true);
                }
            } else if (!this.lastTwoMoves((byte)8)) {
                this.setMove((byte)8, AbstractMonster.Intent.ATTACK, 10, 2, true);
            } else {
                this.setMove(SLUDGE_NAME, (byte)6, AbstractMonster.Intent.ATTACK_DEBUFF, 12);
            }
        }
    }

    @Override
    public void damage(DamageInfo info) {
        super.damage(info);
        if (this.currentHealth <= 0 && !this.halfDead) {
            this.halfDead = true;
            for (AbstractRelic r : AbstractDungeon.player.relics) {
                r.onMonsterDeath(this);
            }
            AbstractDungeon.actionManager.addToTop(new ClearCardQueueAction());
            Iterator s = this.powers.iterator();
            while (s.hasNext()) {
                AbstractPower p = (AbstractPower)s.next();
                if (p.type != AbstractPower.PowerType.DEBUFF && !p.ID.equals("Curiosity") && !p.ID.equals("Unawakened")) continue;
                s.remove();
            }
            this.setMove((byte)3, AbstractMonster.Intent.UNKNOWN);
            this.createIntent();
            AbstractDungeon.actionManager.addToBottom(new ShoutAction(this, DIALOG[0]));
            AbstractDungeon.actionManager.addToBottom(new SetMoveAction(this, 3, AbstractMonster.Intent.UNKNOWN));
            this.firstTurn = true;
            this.form1 = false;
            if (GameActionManager.turn <= 1) {
                UnlockTracker.unlockAchievement("YOU_ARE_NOTHING");
            }
        }
    }

    @Override
    public void die() {
        if (!AbstractDungeon.getCurrRoom().cannotLose) {
            super.die();
            this.useFastShakeAnimation(5.0f);
            CardCrawlGame.screenShake.rumble(4.0f);
            if (this.saidPower) {
                AbstractDungeon.effectList.add(new SpeechBubble(this.hb.cX + this.dialogX, this.hb.cY + this.dialogY, 2.5f, DIALOG[1], false));
                this.deathTimer += 1.5f;
            }
            for (AbstractMonster m : AbstractDungeon.getCurrRoom().monsters.monsters) {
                if (m.isDying || !(m instanceof Cultist)) continue;
                AbstractDungeon.actionManager.addToBottom(new EscapeAction(m));
            }
            this.onBossVictoryLogic();
            UnlockTracker.hardUnlockOverride("CROW");
            UnlockTracker.unlockAchievement("CROW");
        }
    }

    @Override
    public void update() {
        super.update();
        if (!this.isDying && this.animateParticles) {
            this.fireTimer -= Gdx.graphics.getDeltaTime();
            if (this.fireTimer < 0.0f) {
                this.fireTimer = 0.1f;
                AbstractDungeon.effectList.add(new AwakenedEyeParticle(this.skeleton.getX() + this.eye.getWorldX(), this.skeleton.getY() + this.eye.getWorldY()));
                this.wParticles.add(new AwakenedWingParticle());
            }
        }
        Iterator<AwakenedWingParticle> p = this.wParticles.iterator();
        while (p.hasNext()) {
            AwakenedWingParticle e = p.next();
            e.update();
            if (!e.isDone) continue;
            p.remove();
        }
    }

    @Override
    public void render(SpriteBatch sb) {
        for (AwakenedWingParticle p : this.wParticles) {
            if (!p.renderBehind) continue;
            p.render(sb, this.skeleton.getX() + this.back.getWorldX(), this.skeleton.getY() + this.back.getWorldY());
        }
        super.render(sb);
        for (AwakenedWingParticle p : this.wParticles) {
            if (p.renderBehind) continue;
            p.render(sb, this.skeleton.getX() + this.back.getWorldX(), this.skeleton.getY() + this.back.getWorldY());
        }
    }
}

